import socket as sock
import select
import sys
from win32com import client as win32

class LinkMT5Excel:
    def __init__(self, host, port, sheet, cell) -> None:
        try:
            self.HOST = host
            self.PORT = int(port)
            self.server = sock.socket(sock.AF_INET, sock.SOCK_STREAM)
            self.server.setblocking(False)
            self.server.bind((self.HOST, self.PORT))
            self.server.listen()
            self.CONN_LIST = [self.server]
            EXCEL = win32.GetActiveObject('Excel.Application')
            self.SHEET = EXCEL.Worksheets(sheet)
            self.COLUNN, L = cell.split('$')
            self.LINE = int(L)
        except:
            self.CONN_LIST.clear()

    def __WriteInExcel(self, index : int, msg : str) -> None:
        try:
            if self.SHEET:
                self.SHEET.Range(self.COLUNN + str(self.LINE + index)).Value = msg
        except:
            self.SHEET = None
            self.__ShutdownServer()
        print(msg)

    def __ReadInExcel(self, index : int) -> str:
        try:
            if self.SHEET:
                return self.SHEET.Range(self.COLUNN + str(self.LINE + index)).Value
        except:
            self.SHEET = None
            self.__ShutdownServer()    
        return ''

    def __MT5_Disconnect(self, conn) -> None:
        self.__WriteInExcel(2, 'MetaTrader 5 is offline.')
        if conn:
            conn.close()
            if self.CONN_LIST:
                self.CONN_LIST.remove(conn)

    def __ShutdownServer(self) -> None:
        while self.CONN_LIST:
            for conn in self.CONN_LIST:
                conn.close()
                self.CONN_LIST.remove(conn)

    def __Command(self, cmd : str, conn) -> bool:
        if cmd.lower() in '/force server shutdown':
            self.__ShutdownServer()
            return True
        elif cmd.lower() in '/shutdown':
            self.__MT5_Disconnect(conn)
            return True
        return False

    def __Checking(self, conn) -> bool:
        err = len(self.CONN_LIST) > 3
        cmd = False
        if not err:
            try:
                info, msg = conn.recv(256).decode().rstrip(None).split(':')
                if info:
                    if info.lower() in '<mt5 swap message with excel>':
                        cmd = err = self.__Command(msg, conn)
                        if (not cmd) and msg:
                            for slave in self.CONN_LIST:
                                if slave != self.server and slave != conn:
                                    slave.send((msg + '\n').encode())
                    else:
                        err = True
                else:
                    err = True
            except:
                err = True
        if err and (not cmd):
            conn.send('Connection Refused...\n\r'.encode())
            conn.close()
            self.CONN_LIST.remove(conn)
        return not err

    def Run(self) -> None:
        self.__WriteInExcel(0, 'Server online.')
        self.__WriteInExcel(1, f'{self.HOST}:{self.PORT}')
        self.__MT5_Disconnect(None)
        while self.CONN_LIST:
            read, write, err = select.select(self.CONN_LIST, [], [], 0.5)
            for slave in read:
                if slave is self.server:
                    conn, addr = slave.accept()
                    conn.setblocking(False)
                    self.CONN_LIST.append(conn)
                    if not self.__Checking(conn):
                        continue
                    conn.send((self.__ReadInExcel(3) + '\n').encode())
                    self.__WriteInExcel(2, 'MetaTrader 5 is online.')
                else:
                    try:
                        data = slave.recv(1024).decode().rstrip(None)
                        if data:
                            self.__WriteInExcel(4, data)
                            print(f"{data}")
                            if not self.__Command(data, slave):
                                slave.send((self.__ReadInExcel(3) + '\n').encode())
                        else:
                            self.__MT5_Disconnect(slave)
                    except:
                        self.__MT5_Disconnect(slave)

    def __del__(self) -> None:
        for n in range(3):
            self.__WriteInExcel(n, '')
        self.__WriteInExcel(0, 'Server offline...')
'''
if __name__ == '__main__':
    Mt5_Excel = LinkMT5Excel('127.0.0.1', '27015', 'System', 'B$2')
    Mt5_Excel.Run()
    del Mt5_Excel
sys.exit(0)
'''
if __name__ == '__main__':
    if len(sys.argv) == 5:
        Mt5_Excel = LinkMT5Excel(sys.argv[1], sys.argv[2], sys.argv[3], sys.argv[4])
        Mt5_Excel.Run()
        del Mt5_Excel
    else:
        print(f'Usage: {sys.argv[0]} <HOST> <PORT> <SHEET> <CELL>')
